/*
 * Decompiled with CFR 0.152.
 */
package exampleUsage;

import exampleUsage.Item;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import logic.Sorter;

public class DemoSorter {
    public static void main(String[] args) {
        DemoSorter.demoIntegers();
        DemoSorter.demoStrings();
        DemoSorter.demoCustomObjects();
        DemoSorter.demoLargeIntegers();
    }

    static void demoIntegers() {
        ArrayList<Integer> nums1 = new ArrayList<Integer>(List.of(Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(9), Integer.valueOf(2), Integer.valueOf(9), Integer.valueOf(3)));
        ArrayList<Integer> nums2 = new ArrayList<Integer>(nums1);
        Sorter.sortSeq(nums1);
        Sorter.sortPar(nums2);
        System.out.println("Integer seq : " + String.valueOf(nums1));
        System.out.println("Integer par : " + String.valueOf(nums2));
        System.out.println();
    }

    static void demoStrings() {
        ArrayList<String> words1 = new ArrayList<String>(List.of("z", "aa", "b", "aa", "m"));
        ArrayList<String> words2 = new ArrayList<String>(words1);
        Sorter.sortSeq(words1);
        Sorter.sortPar(words2);
        System.out.println("String  seq : " + String.valueOf(words1));
        System.out.println("String  par : " + String.valueOf(words2));
        System.out.println();
    }

    static void demoCustomObjects() {
        ArrayList<Item> items1 = new ArrayList<Item>(List.of(new Item("A", 2), new Item("B", 1), new Item("C", 2), new Item("D", 1), new Item("E", 3)));
        ArrayList<Item> items2 = new ArrayList<Item>(items1);
        Comparator<Item> byCount = Comparator.comparingInt(it -> it.count);
        Sorter.sortSeq(items1, byCount);
        Sorter.sortPar(items2, byCount);
        System.out.println("Objekte seq : " + String.valueOf(items1));
        System.out.println("Objekte par : " + String.valueOf(items2));
        System.out.println();
    }

    static void demoLargeIntegers() {
        int N = 20000000;
        System.out.println("=== Gro\u00dfer Test mit N = 20000000 ===");
        List<Integer> aSeq = DemoSorter.randomIntList(20000000, 42L);
        ArrayList<Integer> aPar = new ArrayList<Integer>(aSeq);
        long t0 = System.nanoTime();
        Sorter.sortSeq(aSeq);
        long t1 = System.nanoTime();
        long t2 = System.nanoTime();
        Sorter.sortPar(aPar);
        long t3 = System.nanoTime();
        long seqMs = (t1 - t0) / 1000000L;
        long parMs = (t3 - t2) / 1000000L;
        System.out.println("Zeit seq : " + seqMs + " ms");
        System.out.println("Zeit par : " + parMs + " ms");
        System.out.printf("Speedup   : %.2fx%n", parMs == 0L ? 0.0 : (double)seqMs * 1.0 / (double)parMs);
        System.out.println("Sort_Par was executed on " + Runtime.getRuntime().availableProcessors() + " logical cores.");
        System.out.println("Seq first/last: " + DemoSorter.headTail(aSeq, 10));
        System.out.println("Par first/last: " + DemoSorter.headTail(aPar, 10));
        System.out.println("equally:  " + aSeq.equals(aPar));
        System.out.println();
    }

    static List<Integer> randomIntList(int n, long seed) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        ArrayList<Integer> list = new ArrayList<Integer>(n);
        int i = 0;
        while (i < n) {
            list.add(rnd.nextInt());
            ++i;
        }
        return list;
    }

    static String headTail(List<Integer> list, int k) {
        int n = list.size();
        List<Integer> head = list.subList(0, Math.min(k, n));
        List<Integer> tail = list.subList(Math.max(0, n - k), n);
        return String.valueOf(head) + " ... " + String.valueOf(tail);
    }
}

